"""
Django settings for psgbi project.

Generated by 'django-admin startproject' using Django 1.8.4.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '_!@k#b!l2%h#145z4o#n-=0x0wbb4s*sdujxp8)n*l&xk+(#qd'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True
DEVELOPMENT = True

ALLOWED_HOSTS = ['*']

# Application definition

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.admin',
    'django.contrib.admindocs',
    'impersonate',
    'captcha',
    'easy_thumbnails',
    'paypal.standard.ipn',
    'modules.abstracts',
    'modules.admin_users',
    'modules.blocks',
    'modules.contact',
    'modules.core',
    'modules.donations',
    'modules.elections',
    'modules.file_manager',
    'modules.mediacentre',
    'modules.meeting_booking',
    'modules.meeting_information',
    'modules.members',
    'modules.notifications',
    'modules.pages',
    'modules.papers',
    'modules.payments',
    'modules.resources',
    'modules.pump_priming',
    'modules.certificates',
)

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
)

ROOT_URLCONF = 'psgbi.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [BASE_DIR + '/templates/',],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'modules.blocks.context_processors.get_menus',
                'modules.blocks.context_processors.get_sidebar',
                'modules.core.context_processors.get_contact_form',
                'modules.members.context_processors.get_member',
                'modules.core.context_processors.get_settings',
                'modules.meeting_information.context_processors.get_meeting'
            ],
        },
    },
]

WSGI_APPLICATION = 'psgbi.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql', # Add 'postgresql_psycopg2', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': 'psgbi',                      # Or path to database file if using sqlite3.
        'USER': 'root',
        'PASSWORD': 'root',
        'HOST': '/Applications/MAMP/tmp/mysql/mysql.sock', # Empty for localhost through domain sockets or '127.0.0.1' for localhost through TCP.
        'PORT': '', # Set to empty string for default.
    }
}

# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'en-gb'
TIME_ZONE = 'UTC'
USE_I18N = True
USE_L10N = True
USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

STATIC_ROOT = BASE_DIR + '/static/'
STATIC_URL = '/static/'

# Additional locations of static files
STATICFILES_DIRS = (
    BASE_DIR + '/static/common/',
)

MEDIA_ROOT = BASE_DIR + '/static/uploads/'
MEDIA_URL = '/media/'

#additional settings

WEBSITE_CODE = 'PSGBI'
WEBSITE_NAME = 'Pancreatic Society of Great Britain and Ireland'
PRIVATE_FILES = '/Applications/MAMP/htdocs/psgbi/private'

URL = 'http://127.0.0.1:8000'
MEETING_URL = 'http://a3726990.ngrok.io'
NGROK_URL = 'http://a3726990.ngrok.io'

CONTACT_EMAIL = 'daniel@calmdigital.com'

EMAIL_HOST = 'smtp.sendgrid.net'
EMAIL_HOST_USER = 'amurphy826'
EMAIL_HOST_PASSWORD = 'qKL*M5tV'
EMAIL_PORT = 587
EMAIL_USE_TLS = True

SETTINGS_IN_CONTEXT = ['WEBSITE_NAME','WEBSITE_CODE','URL','CONTACT_EMAIL']

RECAPTCHA_PUBLIC_KEY = '6LfUfwYAAAAAAESuDyPumAe4kHVURZMvOK91GpSs'
RECAPTCHA_PRIVATE_KEY = '6LfUfwYAAAAAAIW8YrjQL16Vi13dABndqZb_Rb0a'

PAYPAL_RECEIVER_EMAIL = "daniel_1335344598_biz@calmdigital.com"
#PAYPAL_RECEIVER_EMAIL = "colinmckay64@gmail.com"
PAYPAL_PRIVATE_CERT = BASE_DIR + '/paypal/paypal.pem'
PAYPAL_PUBLIC_CERT = BASE_DIR + '/paypal/pubpaypal-sandbox.pem'
#PAYPAL_PUBLIC_CERT = BASE_DIR + '/paypal/pubpaypal-live.pem'
PAYPAL_CERT =  BASE_DIR + '/paypal/paypal_cert_sandbox.pem'
#PAYPAL_CERT = BASE_DIR + '/paypal/paypal_cert_live.pem'
PAYPAL_CERT_ID = 'TDQCRNHVT3LFG'
#PAYPAL_CERT_ID = 'HCEENRDS574SC'
PAYPAL_TEST = True

AUTH_PROFILE_MODULE = 'core.UserProfile'

from modules.safelogging.settings import *
