/**
 * @license Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here.
	// For the complete reference:
	// http://docs.ckeditor.com/#!/api/CKEDITOR.config

    config.allowedContent = true;
    config.extraAllowedContent = 'iframe[allowfullscreen]';
    config.skin = 'kama';

    config.toolbar = 'MyToolbar';

    config.filebrowserBrowseUrl = '/admin/cke-file-uploader/';
    config.filebrowserImageBrowseUrl = '/admin/cke-image-uploader/';

    config.filebrowserWindowWidth= 450;
    config.filebrowserWindowHeight = 500;

    config.extraPlugins = 'tableresize,widget,clipboard,iframe,pastecode,lineutils,colorbutton,placeholder';

    config.colorButton_enableMore = false;
    config.colorButton_colors = '00658d,9cd3d1,08b5c6,00b4c6,3384a4,99dad5';


    config.toolbar_MyToolbar =
    [
        ['Source','Cut','Copy','Paste','PasteText','PasteFromWord','-','Scayt'],
        ['Undo','Redo','-','SelectAll','RemoveFormat'],
        ['Image','PasteCode','Iframe','Table','HorizontalRule','SpecialChar',],
        '/',
        ['Styles','Format'],
        ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
        ['Bold','Italic','Underline', 'Strike','TextColor','Subscript','Superscript'],
        ['NumberedList','BulletedList','-','Outdent','Indent'],
        ['Link','Unlink','Anchor']
    ];

    config.toolbar_PublicToolbar =
    [
        ['Cut','Copy','PasteFromWord'],
        ['Image','Link','Unlink','Table'],
        ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
        ['Format','TextColor','Bold','Italic','Underline'],
        ['NumberedList','BulletedList']
    ];


	// Se the most common block elements.
	config.format_tags = 'p;h1;h2;h3;pre';

};
